function h = expPlot( x, xmin, lambda,varargin)
%EXPPLOT Plot data with exponential fit
%   EXPPLOT(x,xmin,lambda) plots data x and the exponential fit of the form
%   p(x) ~= e^(-lambda*x) for x > xmin.  The plot is made on semilog
%   axes so the fit should be a straight line with slope -lambda.
%
%   This function only accepts integer values of x for now
%
%   Note: xmin should be one of the data points
%
%   This uses an approach modified from:
%   Clauset,Newman,Shalizi Power law Distributions in Empirical Data, 2007

x = reshape(x,numel(x),1);

if ~isempty(setdiff(x,floor(x)))
    error('x must be integer-valued');
end

hld = false;
dataLabels = 'bo';
for i = 1:2:numel(varargin)
    switch varargin{i}
        case 'hold'
            hld = varargin{i+1};
        case 'dataLabels'
            dataLabels = varargin{i+1};
    end
end






% q is unique values in x, sorted
n = length(x);
q = unique(x);
c = hist(x,q)'./n;
c = [[q; q(end)+1] 1-[0; cumsum(c)]]; c(c(:,2)<10^-10,:) = [];



% create data set for fit - this is the survival function (1 - cumulative
% distribution function)
fc = [(xmin:q(end))' exp(lambda*((xmin - (xmin:q(end))')))];
% normalize so that it has the proper value at xmin
fc(:,2) = fc(:,2) .* c(c(:,1)==xmin,2);


if hld
    hold on;
    h(1) = semilogy(c(:,1),c(:,2),dataLabels,'MarkerSize',8,'MarkerFaceColor',[1 1 1]);
    h(2) = semilogy(fc(:,1),fc(:,2),'k--','LineWidth',2);
    hold off;  
else
    figure;
    h(1) = semilogy(c(:,1),c(:,2),dataLabels,'MarkerSize',8,'MarkerFaceColor',[1 1 1]); hold on;
    h(2) = semilogy(fc(:,1),fc(:,2),'k--','LineWidth',2); hold off;
end

% xr  = [10.^floor(log10(min(x))) 10.^ceil(log10(max(x)))];
% xrt = (round(log10(xr(1))):2:round(log10(xr(2))));
% if length(xrt)<4, xrt = (round(log10(xr(1))):1:round(log10(xr(2)))); end;

if ~hld
yr  = [10.^floor(log10(1/n)) 1];
yrt = (round(log10(yr(1))):2:round(log10(yr(2))));
if length(yrt)<4, yrt = (round(log10(yr(1))):1:round(log10(yr(2)))); end;
% set(gca,'XLim',xr,'XTick',10.^xrt);
set(gca,'YLim',yr,'YTick',10.^yrt,'FontSize',16);
ylabel('Pr(X \geq x)','FontSize',16);
xlabel('x','FontSize',16)

end


end

